################################################################################
# Function fish.proc.three():                                                  #
# Similar to Tai and Pan: If a gene occurs in multiple gene functional groups, #
# the gene is kept in the smallest functional group (i.e. the group with the   #
# smallest number of genes) and ignored in the other ones. Be careful: If the  #
# smallest gene functional group is not unique, one of these is chosen by      #
# chance.                                                                   #
#  Input: 1. a gene list 'genes'; each entry itsself is a list of pathway      #
#            names (if a gene is not in any pathway, the entry is 'NA')        #
#         2. the data matrix x                                                 #
#         3. a pathway list 'genesINpath', each entry itself is a list of gene #
#            names included in the respective pathway                          #
#  Output: a vector of gene names with the property from above                 #
################################################################################

whichMIN   <- function(vec) {
              ifelse( sum(min(vec)==vec)==1, which.min(vec),                    # select the extremum of a vector; when
              sample(which(vec==min(vec)),1) )                                  # several components are equal to an extremum,
              }                                                                 # then one of these components is randomly chosen

fish.proc.three <- function(genes,x,genesINpath){

                   annotx <- genes[colnames(x)]
                   out    <- colnames(x)
                   l      <- sapply(annotx,length) == 1
                   names(out)[l]  <- unlist(annotx[l])
                   multiplelist   <- annotx[!l]
                   names(out)[!l] <- sapply(multiplelist, function(ll) ll[whichMIN(sapply(genesINpath[ll],length))])
                   return(out)
                   }